<?php

$link_target     = isset( $settings->link_target_new ) && 'yes' === $settings->link_target_new ? ' target="_blank" rel="noopener bookmark"' : '';
$is_product      = in_array( 'product', (array) $post_type ) || in_array( 'download', (array) $post_type );
$is_wc_product   = in_array( 'product', (array) $post_type ) && class_exists( 'WooCommerce' );
$is_edd_download = in_array( 'download', (array) $post_type ) && class_exists( 'Easy_Digital_Downloads' );
?>
<div class="pp-content-post pp-content-carousel-post pp-grid-<?php echo $settings->post_grid_style_select; ?> <?php echo join( ' ', get_post_class() ); ?>"<?php BB_PowerPack_Post_Helper::print_schema( ' itemscope itemtype="' . PPContentGridModule::schema_itemtype() . '"' ); ?> data-hash="pp-post-<?php echo $post_id; ?>" data-id="<?php echo $post_id; ?>">

	<?php PPContentGridModule::schema_meta(); ?>
	
	<?php if ( 'style-9' == $settings->post_grid_style_select ) {
		PPContentGridModule::render_template( 'post-tile' );
	} else { ?>

	<?php if ( $settings->more_link_type == 'box' ) { ?>
		<a class="pp-post-link" href="<?php echo $permalink; ?>" title="<?php the_title_attribute(); ?>"<?php echo $link_target; ?>></a>
	<?php } ?>

	<?php if ( 'style-1' == $settings->post_grid_style_select ) { ?>

		<<?php echo esc_attr( $settings->title_tag ); ?> class="pp-content-grid-title pp-post-title" itemprop="headline">
			<?php if( $settings->more_link_type == 'button' || $settings->more_link_type == 'title' || $settings->more_link_type == 'title_thumb' ) { ?>
				<a href="<?php echo $permalink; ?>" title="<?php the_title_attribute(); ?>"<?php echo $link_target; ?>>
			<?php } ?>
				<?php the_title(); ?>
			<?php if( $settings->more_link_type == 'button' || $settings->more_link_type == 'title' || $settings->more_link_type == 'title_thumb' ) { ?>
				</a>
			<?php } ?>
		</<?php echo esc_attr( $settings->title_tag ); ?>>

		<div class="pp-content-post-meta pp-post-meta">
			<?php if ( $settings->show_author == 'yes' ) : ?>
				<?php
				// Show post author.
				PPContentGridModule::render_template( 'post-author' );
				?>
			<?php endif; ?>
			<?php if ( $settings->show_date == 'yes' && 'style-5' != $settings->post_grid_style_select ) : ?>
				<?php if($settings->show_author == 'yes' ) : ?>
					<span> <?php echo $settings->meta_separator; ?> </span>
				<?php endif; ?>
				<?php
				// Show post date.
				PPContentGridModule::render_template( 'post-date' );
				?>
			<?php endif; ?>
		</div>
	<?php } ?>

	<?php if ( $settings->show_image == 'yes' ) : ?>
		<?php PPContentGridModule::render_template( 'post-image' ); ?>
	<?php endif; ?>

	<div class="pp-content-carousel-inner pp-content-body">
		<?php if ( 'style-5' == $settings->post_grid_style_select && 'yes' == $settings->show_date ) { ?>
		<div class="pp-content-post-date pp-post-meta">
			<?php if ( pp_is_tribe_events_post( $post_id ) && function_exists( 'tribe_get_start_date' ) ) { ?>
				<span class="pp-post-day"><?php echo tribe_get_start_date( null, false, 'd' ); ?></span>
				<span class="pp-post-month"><?php echo tribe_get_start_date( null, false, 'M' ); ?></span>
			<?php } else { ?>
				<span class="pp-post-day"><?php echo get_the_date('d'); ?></span>
				<span class="pp-post-month"><?php echo get_the_date('M'); ?></span>
			<?php } ?>
		</div>
		<?php } ?>

		<div class="pp-content-post-data">

			<?php if ( 'style-1' != $settings->post_grid_style_select && 'style-4' != $settings->post_grid_style_select ) { ?>
				<<?php echo esc_attr( $settings->title_tag ); ?> class="pp-content-carousel-title pp-post-title" itemprop="headline">
					<?php if ( $settings->more_link_type == 'button' || $settings->more_link_type == 'title' || $settings->more_link_type == 'title_thumb' ) { ?>
						<a href="<?php echo $permalink; ?>" title="<?php the_title_attribute(); ?>"<?php echo $link_target; ?>>
					<?php } ?>
						<?php the_title(); ?>
					<?php if ( $settings->more_link_type == 'button' || $settings->more_link_type == 'title' || $settings->more_link_type == 'title_thumb' ) { ?>
						</a>
					<?php } ?>
				</<?php echo esc_attr( $settings->title_tag ); ?>>
				<?php if ( 'style-2' == $settings->post_grid_style_select ) { ?>
					<span class="pp-post-title-divider"></span>
				<?php } ?>
			<?php } ?>

			<?php if ( ( $settings->show_author == 'yes' || $settings->show_date == 'yes' || $settings->show_categories == 'yes' )
				&& ( 'style-1' != $settings->post_grid_style_select ) ) : ?>

			<div class="pp-content-post-meta pp-post-meta">
				<?php if ( $settings->show_author == 'yes' ) : ?>
					<?php
					// Show post author.
					PPContentGridModule::render_template( 'post-author' );
					?>
				<?php endif; ?>

				<?php if ( $settings->show_date == 'yes' && 'style-5' != $settings->post_grid_style_select && 'style-6' != $settings->post_grid_style_select ) : ?>
					<?php if ( $settings->show_author == 'yes' ) : ?>
						<span> <?php echo $settings->meta_separator; ?> </span>
					<?php endif; ?>
					<?php
					// Show post date.
					PPContentGridModule::render_template( 'post-date' );
					?>
				<?php endif; ?>

				<?php if ( 'style-6' == $settings->post_grid_style_select || 'style-5' == $settings->post_grid_style_select ) : ?>
					<?php if ( $settings->show_author == 'yes' && $settings->show_categories == 'yes' && ! empty( $terms_list ) ) : ?>
						<span> <?php echo $settings->meta_separator; ?> </span>
					<?php endif; ?>
					<?php if ( $settings->show_categories == 'yes' ) { ?>
					<span class="pp-content-post-category">
						<?php if ( ! empty( $terms_list ) ) { ?>
							<?php $i = 1;
							foreach ($terms_list as $term):
								?>
							<?php if( $i == count($terms_list) ) { ?>
								<a href="<?php echo get_term_link($term); ?>" class="pp-post-meta-term"><?php echo $term->name; ?></a>
							<?php } else { ?>
								<a href="<?php echo get_term_link($term); ?>" class="pp-post-meta-term"><?php echo $term->name; ?></a> <?php echo ! empty( $settings->meta_separator ) ? $settings->meta_separator : '/'; ?>
							<?php } ?>
							<?php $i++; endforeach; ?>
						<?php } ?>
					</span>
					<?php } ?>
				<?php endif; ?>

			</div>
			<?php endif; ?>

			<?php if ( $is_wc_product && $settings->product_rating == 'yes' ) { ?>
				<?php PPContentGridModule::render_template( 'product-rating' ); ?>
			<?php } ?>

			<?php if ( in_array( 'tribe_events', (array) $post_type ) && ( class_exists( 'Tribe__Events__Main' ) && class_exists( 'FLThemeBuilderLoader' ) ) ) { ?>
				<?php PPContentGridModule::render_template( 'event-content' ); ?>
			<?php } ?>

			<?php do_action( 'pp_cg_before_post_content', $post_id, $settings ); ?>

			<?php if ( $settings->show_content == 'yes' || $settings->show_content == 'custom' ) : ?>
				<?php PPContentGridModule::render_template( 'post-content' ); ?>
			<?php endif; ?>

			<?php do_action( 'pp_cg_after_post_content', $post_id, $settings ); ?>

			<?php if ( $settings->more_link_text != '' && $settings->more_link_type == 'button' && ! $is_wc_product && ! $is_edd_download ) :
				PPContentGridModule::render_template( 'custom-button' );
			endif; ?>

			<?php if ( $is_wc_product || $is_edd_download ) {
				if ( 'yes' == $settings->product_price ) {
					PPContentGridModule::render_template( 'product-price' );
				}
				if ( 'yes' == $settings->product_button ) {
					PPContentGridModule::render_template( 'cart-button' );
				} else {
					if ( $settings->more_link_text != '' && $settings->more_link_type == 'button' ) {
						PPContentGridModule::render_template( 'custom-button' );
					}
				}
			} ?>

			<?php if ( ( $settings->show_categories == 'yes' && !empty($terms_list) ) && ('style-3' != $settings->post_grid_style_select && 'style-5' != $settings->post_grid_style_select && 'style-6' != $settings->post_grid_style_select) ) : ?>
				<?php PPContentGridModule::render_template( 'post-terms' ); ?>
			<?php endif; ?>
		</div>
	</div>
	<?php } ?>
</div>
